/* 
 * HTML5 ✰ Boilerplate
 * Plugin Directory
 *
 * Place any jQuery/helper plugins in here, instead of separate, slower script files.
 *
 * 1. Lightweight wrapper for console.log - paulirish.com/2009/log-a-lightweight-wrapper-for-consolelog/
 * 2. jQuery popup windows - http://swip.codylindley.com/popupWindowDemo.html
 * 3. jQuery browser and OS detection - http://www.stoimen.com/blog/2009/07/16/jquery-browser-and-os-detection-plugin/
 * 4. getUrlParameters based on http://ejohn.org/blog/search-and-dont-replace/
 * 5. PluginDetect v0.7.5 by Eric Gerds www.pinlady.net/PluginDetect with custom Autograph detection.
 * 6. updatealert simple alert for updates optional changebutton see http://docs.jquery.com/Plugins/Authoring
	 $('<p>Hello World!</p>').updatealert({changebutton: true});
 * 7. updatehelp adds an OK or alert to help page see http://docs.jquery.com/Plugins/Authoring
	 $('<p>Hello World!</p>').updatehelp({updaterequired: true});
 * 8. embedautograph adds autograph code for embedding given autograph file see http://docs.jquery.com/Plugins/Authoring
	 $( "#autograph-player" ).embedautograph( filename: '', pagetype: '' )
	 9. macfallback adds an image with a click event to open the agg file in the Autograph Mac Player 
	 $( "#autograph-player" ).macfallback( { href: '', filename: '', pagetype: '' } );
	 10. pluginerror simple alert for updates optional id for containing div
	 $('<p>Hello World!</p>').pluginerror({container: '#mydiv'});
 */

/* =============================================================================
   1. Lightweight Wrapper for Console Log
   ========================================================================== */

// usage: log('inside coolFunc', this, arguments);
// paulirish.com/2009/log-a-lightweight-wrapper-for-consolelog/
window.log = function(){
  log.history = log.history || [];   // store logs to an array for reference
  log.history.push(arguments);
  if(this.console) {
    arguments.callee = arguments.callee.caller;
    var newarr = [].slice.call(arguments);
    (typeof console.log === 'object' ? log.apply.call(console.log, console, newarr) : console.log.apply(console, newarr));
  }
};

// make it safe to use console.log always
(function(b){function c(){}for(var d="assert,count,debug,dir,dirxml,error,exception,group,groupCollapsed,groupEnd,info,log,timeStamp,profile,profileEnd,time,timeEnd,trace,warn".split(","),a;a=d.pop();){b[a]=b[a]||c}})((function(){try
{console.log();return window.console;}catch(err){return window.console={};}})());

/* =============================================================================
   2. jQuery popup windows
   ========================================================================== */

(function($){ 		  
	$.fn.popupWindow = function(instanceSettings){
		
		return this.each(function(){
		
		$(this).click(function(event){
		
		event.preventDefault();
		
		$.fn.popupWindow.defaultSettings = {
			centerBrowser:0, // center window over browser window? {1 (YES) or 0 (NO)}. overrides top and left
			centerScreen:0, // center window over entire screen? {1 (YES) or 0 (NO)}. overrides top and left
			height:500, // sets the height in pixels of the window.
			left:0, // left position when the window appears.
			location:0, // determines whether the address bar is displayed {1 (YES) or 0 (NO)}.
			menubar:0, // determines whether the menu bar is displayed {1 (YES) or 0 (NO)}.
			resizable:0, // whether the window can be resized {1 (YES) or 0 (NO)}. Can also be overloaded using resizable.
			scrollbars:0, // determines whether scrollbars appear on the window {1 (YES) or 0 (NO)}.
			status:0, // whether a status line appears at the bottom of the window {1 (YES) or 0 (NO)}.
			width:500, // sets the width in pixels of the window.
			windowName:null, // name of window set from the name attribute of the element that invokes the click
			windowURL:null, // url used for the popup
			top:0, // top position when the window appears.
			toolbar:0 // determines whether a toolbar (includes the forward and back buttons) is displayed {1 (YES) or 0 (NO)}.
		};
		
		settings = $.extend({}, $.fn.popupWindow.defaultSettings, instanceSettings || {});
		
		var windowFeatures =    'height=' + settings.height +
								',width=' + settings.width +
								',toolbar=' + settings.toolbar +
								',scrollbars=' + settings.scrollbars +
								',status=' + settings.status + 
								',resizable=' + settings.resizable +
								',location=' + settings.location +
								',menuBar=' + settings.menubar;

				settings.windowName = this.name || settings.windowName;
				settings.windowURL = this.href || settings.windowURL;
				var centeredY,centeredX;
			
				if(settings.centerBrowser){
						
					if ($.browser.msie) {//hacked together for IE browsers
						centeredY = (window.screenTop - 120) + ((((document.documentElement.clientHeight + 120)/2) - (settings.height/2)));
						centeredX = window.screenLeft + ((((document.body.offsetWidth + 20)/2) - (settings.width/2)));
					}else{
						centeredY = window.screenY + (((window.outerHeight/2) - (settings.height/2)));
						centeredX = window.screenX + (((window.outerWidth/2) - (settings.width/2)));
					}
					window.open(settings.windowURL, settings.windowName, windowFeatures+',left=' + centeredX +',top=' + centeredY).focus();
				}else if(settings.centerScreen){
					centeredY = (screen.height - settings.height)/2;
					centeredX = (screen.width - settings.width)/2;
					window.open(settings.windowURL, settings.windowName, windowFeatures+',left=' + centeredX +',top=' + centeredY).focus();
				}else{
					window.open(settings.windowURL, settings.windowName, windowFeatures+',left=' + settings.left +',top=' + settings.top).focus();	
				}
				return false;
			});
			
		});	
	};
})(jQuery);

/* =============================================================================
   3. jQuery browser and OS detection
	 http://www.stoimen.com/blog/2009/07/16/jquery-browser-and-os-detection-plugin/
   ========================================================================== */

(function() {
	
	var BrowserDetect = {
		init: function () {
			this.browser = this.searchString(this.dataBrowser) || "An unknown browser";
			this.version = this.searchVersion(navigator.userAgent)
				|| this.searchVersion(navigator.appVersion)
				|| "an unknown version";
			this.OS = this.searchString(this.dataOS) || "an unknown OS";
			
		},
		searchString: function (data) {
			for (var i=0;i<data.length;i++)	{
				var dataString = data[i].string;
				var dataProp = data[i].prop;
				this.versionSearchString = data[i].versionSearch || data[i].identity;
				if (dataString) {
					if (dataString.indexOf(data[i].subString) != -1)
						return data[i].identity;
				}
				else if (dataProp)
					return data[i].identity;
			}
		},
		searchVersion: function (dataString) {
			var index = dataString.indexOf(this.versionSearchString);
			if (index == -1) return;
			return parseFloat(dataString.substring(index+this.versionSearchString.length+1));
		},
		dataBrowser: [
			{
				string: navigator.userAgent,
				subString: "AutographPlayer",
				identity: "AutographMacPlayer"
			},			
			{
				string: navigator.userAgent,
				subString: "Chrome",
				identity: "Chrome"
			},
			{ 	string: navigator.userAgent,
				subString: "OmniWeb",
				versionSearch: "OmniWeb/",
				identity: "OmniWeb"
			},
			{
				string: navigator.vendor,
				subString: "Apple",
				identity: "Safari",
				versionSearch: "Version"
			},
			{
				prop: window.opera,
				identity: "Opera"
			},
			{
				string: navigator.vendor,
				subString: "iCab",
				identity: "iCab"
			},
			{
				string: navigator.vendor,
				subString: "KDE",
				identity: "Konqueror"
			},
			{
				string: navigator.userAgent,
				subString: "Firefox",
				identity: "Firefox"
			},
			{
				string: navigator.vendor,
				subString: "Camino",
				identity: "Camino"
			},
			{		// for newer Netscapes (6+)
				string: navigator.userAgent,
				subString: "Netscape",
				identity: "Netscape"
			},
			{
				string: navigator.userAgent,
				subString: "MSIE",
				identity: "Explorer",
				versionSearch: "MSIE"
			},
			{
				string: navigator.userAgent,
				subString: "Gecko",
				identity: "Mozilla",
				versionSearch: "rv"
			},
			{ 		// for older Netscapes (4-)
				string: navigator.userAgent,
				subString: "Mozilla",
				identity: "Netscape",
				versionSearch: "Mozilla"
			}
		],
		dataOS : [
			{
				string: navigator.userAgent,
				subString: "AutographPlayer",
				identity: "Mac"
			},
			{
				string: navigator.platform,
				subString: "Win",
				identity: "Windows"
			},
			{
				string: navigator.platform,
				subString: "Mac",
				identity: "Mac"
			},
			{
				string: navigator.userAgent,
				subString: "iPhone",
				identity: "iPhone/iPod"
		  },
			{
				string: navigator.platform,
				subString: "Linux",
				identity: "Linux"
			}
		]
	
	};
	
	BrowserDetect.init();
	
	window.$.client = { os : BrowserDetect.OS, browser : BrowserDetect.browser };
	
})();


/* =============================================================================
   4. getUrlParameters based on http://ejohn.org/blog/search-and-dont-replace/
   ========================================================================== */

function getUrlParameters() {
	var map = {};
	var pattern = /[?&]+([^=&]+)=([^&]*)/gi;
	var parts = window.location.search.replace(pattern, 
		function(m, key, value) {
			map[key] = value;
		}
	);
	return map; 
}

/* =============================================================================
   5. PluginDetect v0.7.5 by Eric Gerds www.pinlady.net/PluginDetect with custom Autograph detection.
   ========================================================================== */
	 
var PluginDetect = {
    version: "0.7.5",
    name: "PluginDetect",
    handler: function (c, b, a) {
        return function () {
            c(b, a)
        }
    },
    isDefined: function (b) {
        return typeof b != "undefined"
    },
    isArray: function (b) {
        return (/array/i).test(Object.prototype.toString.call(b))
    },
    isFunc: function (b) {
        return typeof b == "function"
    },
    isString: function (b) {
        return typeof b == "string"
    },
    isNum: function (b) {
        return typeof b == "number"
    },
    isStrNum: function (b) {
        return (typeof b == "string" && (/\d/).test(b))
    },
    getNumRegx: /[\d][\d\.\_,-]*/,
    splitNumRegx: /[\.\_,-]/g,
    getNum: function (b, c) {
        var d = this,
            a = d.isStrNum(b) ? (d.isDefined(c) ? new RegExp(c) : d.getNumRegx).exec(b) : null;
        return a ? a[0] : null
    },
    compareNums: function (h, f, d) {
        var e = this,
            c, b, a, g = parseInt;
        if (e.isStrNum(h) && e.isStrNum(f)) {
            if (e.isDefined(d) && d.compareNums) {
                return d.compareNums(h, f)
            }
            c = h.split(e.splitNumRegx);
            b = f.split(e.splitNumRegx);
            for (a = 0;
            a < Math.min(c.length, b.length);
            a++) {
                if (g(c[a], 10) > g(b[a], 10)) {
                    return 1
                }
                if (g(c[a], 10) < g(b[a], 10)) {
                    return -1
                }
            }
        }
        return 0
    },
    formatNum: function (b, c) {
        var d = this,
            a, e;
        if (!d.isStrNum(b)) {
            return null
        }
        if (!d.isNum(c)) {
            c = 4
        }
        c--;
        e = b.replace(/\s/g, "").split(d.splitNumRegx).concat(["0", "0", "0", "0"]);
        for (a = 0;
        a < 4;
        a++) {
            if (/^(0+)(.+)$/.test(e[a])) {
                e[a] = RegExp.$2
            }
            if (a > c || !(/\d/).test(e[a])) {
                e[a] = "0"
            }
        }
        return e.slice(0, 4).join(",")
    },
    $$hasMimeType: function (a) {
        return function (d) {
            if (!a.isIE && d) {
                var c, b, e, f = a.isString(d) ? [d] : d;
                if (!f || !f.length) {
                    return null
                }
                for (e = 0;
                e < f.length;
                e++) {
                    if (/[^\s]/.test(f[e]) && (c = navigator.mimeTypes[f[e]]) && (b = c.enabledPlugin) && (b.name || b.description)) {
                        return c
                    }
                }
            }
            return null
        }
    },
    findNavPlugin: function (l, e, c) {
        var j = this,
            h = new RegExp(l, "i"),
            d = (!j.isDefined(e) || e) ? /\d/ : 0,
            k = c ? new RegExp(c, "i") : 0,
            a = navigator.plugins,
            g = "",
            f, b, m;
        for (f = 0;
        f < a.length;
        f++) {
            m = a[f].description || g;
            b = a[f].name || g;
            if ((h.test(m) && (!d || d.test(RegExp.leftContext + RegExp.rightContext))) || (h.test(b) && (!d || d.test(RegExp.leftContext + RegExp.rightContext)))) {
                if (!k || !(k.test(m) || k.test(b))) {
                    return a[f]
                }
            }
        }
        return null
    },
    getMimeEnabledPlugin: function (a, f) {
        var e = this,
            b, c = new RegExp(f, "i"),
            d = "";
        if ((b = e.hasMimeType(a)) && (b = b.enabledPlugin) && (c.test(b.description || d) || c.test(b.name || d))) {
            return b
        }
        return 0
    },
    AXO: window.ActiveXObject,
    getAXO: function (b) {
        var f = null,
            d, c = this,
            a;;
        try {
            f = new c.AXO(b);
        } catch (d) {}
        return f
    },
    convertFuncs: function (g) {
        var a, h, f, b = /^[\$][\$]/,
            d = {},
            c = this;
        for (a in g) {
            if (b.test(a)) {
                d[a] = 1
            }
        }
        for (a in d) {
            try {
                h = a.slice(2);
                if (h.length > 0 && !g[h]) {
                    g[h] = g[a](g);
                    delete g[a]
                }
            } catch (f) {}
        }
    },
    initScript: function () {
        var c = this,
            a = navigator,
            e = "/",
            i = a.userAgent || "",
            g = a.vendor || "",
            b = a.platform || "",
            h = a.product || "";;;;
        c.OS = 100;
        if (b) {
            var f, d = ["Win", 1, "Mac", 2, "Linux", 3, "FreeBSD", 4, "iPhone", 21.1, "iPod", 21.2, "iPad", 21.3, "Win.*CE", 22.1, "Win.*Mobile", 22.2, "Pocket\\s*PC", 22.3, "", 100];
            for (f = d.length - 2;
            f >= 0;
            f = f - 2) {
                if (d[f] && new RegExp(d[f], "i").test(b)) {
                    c.OS = d[f + 1];
                    break
                }
            }
        }
        c.convertFuncs(c);;
        c.isIE = new Function("return " + e + "*@cc_on!@*" + e + "false")();
        c.verIE = c.isIE && (/MSIE\s*(\d+\.?\d*)/i).test(i) ? parseFloat(RegExp.$1, 10) : null;
        c.ActiveXEnabled = false;;;
        if (c.isIE) {
            var f, j = ["Msxml2.XMLHTTP", "Msxml2.DOMDocument", "Microsoft.XMLDOM", "ShockwaveFlash.ShockwaveFlash", "TDCCtl.TDCCtl", "Shell.UIHelper", "Scripting.Dictionary", "wmplayer.ocx"];
            for (f = 0;
            f < j.length;
            f++) {
                if (c.getAXO(j[f])) {
                    c.ActiveXEnabled = true;
                    break
                }
            }
            c.head = c.isDefined(document.getElementsByTagName) ? document.getElementsByTagName("head")[0] : null
        }
        c.isGecko = (/Gecko/i).test(h) && (/Gecko\s*\/\s*\d/i).test(i);
        c.verGecko = c.isGecko ? c.formatNum((/rv\s*\:\s*([\.\,\d]+)/i).test(i) ? RegExp.$1 : "0.9") : null;;;
        c.isSafari = (/Safari\s*\/\s*\d/i).test(i) && (/Apple/i).test(g);;
        c.isChrome = (/Chrome\s*\/\s*(\d[\d\.]*)/i).test(i);
        c.verChrome = c.isChrome ? c.formatNum(RegExp.$1) : null;;;
        c.isOpera = (/Opera\s*[\/]?\s*(\d+\.?\d*)/i).test(i);
        c.verOpera = c.isOpera && ((/Version\s*\/\s*(\d+\.?\d*)/i).test(i) || 1) ? parseFloat(RegExp.$1, 10) : null;;;;;

    },
    init: function (c) {
        var b = this,
            a, c;
        if (!b.isString(c)) {
            return -3
        }
        if (c.length == 1) {
            b.getVersionDelimiter = c;
            return -3
        }
        c = c.toLowerCase().replace(/\s/g, "");
        a = b[c];
        if (!a || !a.getVersion) {
            return -3
        }
        b.plugin = a;
        if (!b.isDefined(a.installed)) {
            a.installed = a.version = a.version0 = a.getVersionDone = null;
            a.$ = b;
            a.pluginName = c
        }
        b.garbage = false;
        if (b.isIE && !b.ActiveXEnabled) {
            if (a !== b.java) {
                return -2
            }
        }
        return 1
    },
    fPush: function (b, a) {
        var c = this;
        if (c.isArray(a) && (c.isFunc(b) || (c.isArray(b) && b.length > 0 && c.isFunc(b[0])))) {
            a.push(b)
        }
    },
    callArray: function (b) {
        var c = this,
            a;
        if (c.isArray(b)) {
            for (a = 0;
            a < b.length;
            a++) {
                if (b[a] === null) {
                    return
                }
                c.call(b[a]);
                b[a] = null
            }
        }
    },
    call: function (c) {
        var b = this,
            a = b.isArray(c) ? c.length : -1;
        if (a > 0 && b.isFunc(c[0])) {
            c[0](b, a > 1 ? c[1] : 0, a > 2 ? c[2] : 0, a > 3 ? c[3] : 0)
        } else {
            if (b.isFunc(c)) {
                c(b)
            }
        }
    },
    $$isMinVersion: function (a) {
        return function (h, g, d, c) {
            var e = a.init(h),
                f, b = -1,
                j;;
            if (e < 0) {
                return e
            }
            f = a.plugin;
            g = a.formatNum(a.isNum(g) ? g.toString() : (a.isStrNum(g) ? a.getNum(g) : "0"));;
            if (f.getVersionDone != 1) {
                f.getVersion(g, d, c);
                if (f.getVersionDone === null) {
                    f.getVersionDone = 1
                }
            }
            a.cleanup();
            if (f.installed !== null) {
                b = f.installed <= 0.5 ? f.installed : (f.installed == 0.7 ? 1 : (f.version === null ? 0 : (a.compareNums(f.version, g, f) >= 0 ? 1 : -1)))
            };
            return b
        }
    },
    getVersionDelimiter: ",",
    $$getVersion: function (a) {
        return function (g, d, c) {
            var e = a.init(g),
                f, b, h;;
            if (e < 0) {
                return null
            };
            f = a.plugin;
            if (f.getVersionDone != 1) {
                f.getVersion(null, d, c);
                if (f.getVersionDone === null) {
                    f.getVersionDone = 1
                }
            }
            a.cleanup();
            b = (f.version || f.version0);
            b = b ? b.replace(a.splitNumRegx, a.getVersionDelimiter) : b;;
            return b
        }
    },
    cleanup: function () {},
    $$onDetectionDone: function (a) {
        return function (h, g, c, b) {
            var d = a.init(h),
                j, e;
            if (d == -3) {
                return -1
            }
            e = a.plugin;;
            if (!a.isArray(e.funcs)) {
                e.funcs = []
            }
            if (e.getVersionDone != 1) {
                j = a.isMinVersion ? a.isMinVersion(h, "0", c, b) : a.getVersion(h, c, b)
            }
            if (e.installed != -0.5 && e.installed != 0.5) {;
                a.call(g);;
                return 1
            }
            if (e.NOTF) {
                a.fPush(g, e.funcs);
                return 0
            }
            return 1
        }
    },
		autograph: {
        mimeType: ["application/x-agraph-plugin"],
        progID: "Autograph.AutographCtrl",
        classID: "clsid:2DFFF8F7-027B-46FB-9E24-21434BFCB82D",
        getVersion: function () {
            var h = this,
                f = h.$,
                j, k = null,
                c = null,
                a = null;
            if (!f.isIE) {
                c = f.findNavPlugin("Autograph", 0);
                if (c && c.description && f.hasMimeType(h.mimeType)) {
                    k = f.getNum(c.description)
                }
            } else {                
                c = f.getAXO(h.progID);
								try {
								    a = c.Version;
                } catch (j) {}
                if (f.isString(a) && a.length > 0) {
                    k = f.getNum(a);	
                }
            }
						h.installed = c && k ? 1 : (c ? 0 : -1.5);
            h.version = f.formatNum(k);
        }
    },
    zz: 0
};
PluginDetect.initScript();

/* =============================================================================
   6. updatealert simple alert for updates optional changebutton see http://docs.jquery.com/Plugins/Authoring
	 $('<p>Hello World!</p>').updatealert({changebutton: true});
   ========================================================================== */

(function ($) {
	
	var methods = {
		
		init : function( options ){
		  return this.each(function() {

				var settings = $.extend( {
					'changebutton' : false
				}, options);
			
				if (settings.changebutton == true) {
			  	$('header a.help').addClass('upgrade');
		  	}
				
				var $this = $(this);
					
				$this.addClass('alert').prependTo('#autograph-instructions .margin-wrapper').fadeIn();

      });			
		}
  };

  $.fn.updatealert = function( method ) {
    
    // Method calling logic
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on jQuery.updatealert' );
    }    
  
  };		
	
})(jQuery);
	
/* =============================================================================
   7. updatehelp adds an OK or alert to help page see http://docs.jquery.com/Plugins/Authoring
	 $('<p>Hello World!</p>').updatehelp({updaterequired: true});
   ========================================================================== */

(function ($) {
	
	var methods = {
		
		init : function( options ){
		  return this.each(function() {

				var settings = $.extend( {
					'updaterequired' : false
				}, options);
			
				var $this = $(this);
				
				if (settings.updaterequired) {
			  	$this.addClass('updaterequired');
		  	} 
				else 
				{
					$this.addClass('updatenotrequired');
				}
									
				$this.insertAfter('#player-installation h1').fadeIn();

      });			
		}
  };

  $.fn.updatehelp = function( method ) {
    
    // Method calling logic
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on jQuery.updatehelp' );
    }    
  
  };		
	
})(jQuery);

	
/* =============================================================================
   8. embedautograph adds autograph code for embedding given autograph file see http://docs.jquery.com/Plugins/Authoring
	 $( "#autograph-player" ).embedautograph( AUTOGRAPHACTIVITY.agg );
   ========================================================================== */

(function ($) {
	
	var methods = {
		
		init : function( options ){
		  return this.each(function() {

				var settings = $.extend( {
					filename: '',
					pagetype: '2D',
					showtoolbar: '1',
					width: '100%',
					height: '100%'					
				}, options);
			
				var $this = $(this);
				
				$.template( "aggTemplate", "<object class='agraphaxcontrol' classid='clsid:2dfff8f7-027b-46fb-9e24-21434bfcb82d' codebase='http://www.autograph-maths.com/ieplayer/AutographPlayer.cab#version=3,5,0,6' width={{=width}} height={{=height}}><param name='File' value='{{=filename}}' /><param name='PageType' value='{{=pagetype}}' /><param name='ShowToolbar' value='{{=showtoolbar}}' /><embed src='{{=filename}}' type='application/x-agraph-plugin' pluginspage='http://www.autograph-maths.com/firefoxplugin/AutographFirefoxPlugin.xpi' width={{=width}} height={{=height}} PageType={{=pagetype}} ShowToolbar={{=showtoolbar}}></embed></object>" );
				
				$this.html(
					$.render( settings, "aggTemplate" )
				);
								
      });			
		}
  };

  $.fn.embedautograph = function( method ) {
    
    // Method calling logic
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on jQuery.embedautograph' );
    }    
  
  };		
	
})(jQuery);

/* =============================================================================
   9. macfallback adds an image with a click event to open the agg file in the Autograph Mac Player 
	 $( "#autograph-player" ).macfallback( { href: '', filename: '', pagetype: '' } );
   ========================================================================== */

(function ($) {
	
	var methods = {
		
		init : function( options ){
		  return this.each(function() {

				var settings = $.extend( {
					href: '',
					filename: '',
					pagetype: '2D',
					screenshot: 'http://www.autograph-maths.com/activities/simonwoodhead/img/click-to-play.png',
					screenshothover: 'http://www.autograph-maths.com/activities/simonwoodhead/img/click-to-play.png',
					width: '640px',
					height: '480px'							
				}, options);
				
				settings.dir = settings.href.substring(0, settings.href.lastIndexOf('/') + 1);
				
				var $this = $(this);
				
				var myurl = 'autograph:url=http://autograph-maths.com/activities/open.html?path=' + settings.dir + settings.filename + '&type=' + settings.pagetype + ';title=Autograph%20Activities;width=1024;height=608;minwidth=640;minheight=480;toolbar=0;location=0;';
				
				var appendIframe = function() {
				  $('<iframe />', {
						src: myurl,
						style: 'display:none'
					}).appendTo('body');
				};
				
				$('<a>', {
					href: '#',
					click: appendIframe,
					text: 'Click to Play'										
				}).width(settings.width).height(settings.height).addClass('ir autograph-player-mac-fallback').css("background-image", "url(" + settings.screenshot + ")")
				 .css("background-color", "black")
				 .hover(
				   function() { $(this).css("background-image", "url(" + settings.screenshothover + ")") },
					 function() { $(this).css("background-image", "url(" + settings.screenshot + ")") }
				 )				
				.appendTo(this);
																
      });			
		}
  };

  $.fn.macfallback = function( method ) {
    
    // Method calling logic
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on jQuery.macfallback' );
    }    
  
  };		
	
})(jQuery);


/* =============================================================================
   10. pluginerror simple alert for updates optional id for containing div
	 $('<p>Hello World!</p>').pluginerror({container: '#mydiv'});
   ========================================================================== */

(function ($) {
	
	var methods = {
		
		init : function( options ){
		  return this.each(function() {

				var settings = $.extend( {
					container: '#plugin-error-container'
				}, options);
			
				if (settings.changebutton == true) {
			  	$('header a.help').addClass('upgrade');
		  	}
				
				var $this = $(this);
					
				$this.addClass('alert').prependTo(settings.container).fadeIn();

      });			
		}
  };

  $.fn.pluginerror = function( method ) {
    
    // Method calling logic
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on jQuery.pluginerror' );
    }    
  
  };		
	
})(jQuery);


/* =============================================================================
   11. mobilefallback adds a screenshot or YouTube video
	 $( "#autograph-player" ).mobilefallback( { width: '', height: '', screenshot: '', youtube: '' } );
   ========================================================================== */

(function ($) {
	
	var methods = {
		
		init : function( options ){
		  return this.each(function() {

				var settings = $.extend( {
					screenshot: 'http://www.autograph-maths.com/activities/simonwoodhead/img/not-supported.png',
					screenshothover: 'http://www.autograph-maths.com/activities/simonwoodhead/img/not-supported.png',
					youtube: '',
					width: '640px',
					height: '480px'							
				}, options);
				
				var $this = $(this);
				
				if (settings.youtube !== ''){
											
					$('<iframe />', {
						src: settings.youtube,
						width: settings.width,
						height: settings.height,
						allowfullscreen: true,
						frameborder: "0"
					}).appendTo(this);
					
				} else {
					
					$('<div>')
						.width(settings.width)
						.height(settings.height)
						.addClass('autograph-player-mac-fallback')
						.css("background-image", "url(" + settings.screenshot + ")")
						.css("background-color", "black")
						.hover(
							function() { $(this).css("background-image", "url(" + settings.screenshothover + ")") },
							function() { $(this).css("background-image", "url(" + settings.screenshot + ")") }
						)				
						.appendTo(this);	
									
				}
				
      });			
		}
  };

  $.fn.mobilefallback = function( method ) {
    
    // Method calling logic
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist on jQuery.mobilefallback' );
    }    
  
  };		
	
})(jQuery);